// (CVN) - Candy Valley Network GmbH

#include "Adapters/LovenseConnectMobileAdapter.h"

// EXTERNAL INCLUDES
#include <HttpModule.h>
#include <IHttpRequest.h>

// INTERNAL INCLUDES
#include "LovenseManager.h"
#include <Serialization/JsonReader.h>
#include <Serialization/JsonSerializer.h>


LovenseConnectMobileAdapter::LovenseConnectMobileAdapter()
	: LovenseConnectAdapterBase() {}

void LovenseConnectMobileAdapter::GetToys(FOnLovenseGetToysResponse callback) {
#if WITH_LOVENSE
	TMap<FString, FString> headers;
	//headers.Add(TEXT("Content-Type"), TEXT("application/json"));
	FString url = FString::Printf(TEXT("%s://%s:%d/GetToys"), *this->webProtocol, *this->deviceIp, this->webProtocol.Equals(TEXT("https")) ? this->adapterDescription.httpsPort : this->adapterDescription.httpPort);
	RequestToys(url, true, TEXT("GET"), TEXT(""), headers, callback);
#endif
}

void LovenseConnectMobileAdapter::WebThread_SendCommand(const FString& command, FOnLovenseResponse callback) {
//	FHttpRequestPtr httpRequest = FHttpModule::Get().CreateRequest();
//#if WITH_LOVENSE
//	httpRequest->SetVerb(this->GetVerb());
//	httpRequest->SetURL(FString::Printf(TEXT("%s://%s:%d/%s"), *this->webProtocol, *this->deviceIp, this->adapterDescription.httpsPort, *command));
//#endif
//	return httpRequest;
#if WITH_LOVENSE
	FString url = TEXT("");
	url = FString::Printf(TEXT("%s://%s:%d/%s"), *this->webProtocol, *this->deviceIp, this->webProtocol.Equals(TEXT("https")) ? this->adapterDescription.httpsPort : this->adapterDescription.httpPort,*command);
	TMap<FString, FString> headers;
	headers.Add(TEXT("Content-Type"), TEXT("application/json"));
	LovenseWebThread* webThread = new LovenseWebThread(url, true, TEXT("POST"), TEXT(""), headers, TEXT("thread_sendCommand"), callback, [&](const FString response, FOnLovenseResponse callback) {
		//if (!FLovenseManager::Get()->IsLovenseRunning()) return;

		// Parse response into a json object.
		TSharedPtr<FJsonObject> jsonObject = MakeShareable(new FJsonObject());
		TSharedRef<TJsonReader<TCHAR>> jsonReader = TJsonReaderFactory<TCHAR>::Create(response);
		FJsonSerializer::Deserialize(jsonReader, jsonObject);

		// Retrieve response status.
		TSharedPtr<FJsonValue> codeValue = jsonObject->GetField<EJson::None>(TEXT("code"));
		// If there is no "code" field or the code is not 200 (which means success), execute callback with -1 to indicate that we couldn't determine the battery status.
		if (codeValue->IsNull()) return (void)callback.ExecuteIfBound(-1);
		int32 code = FMath::RoundHalfFromZero(codeValue->AsNumber());
		return (void)callback.ExecuteIfBound(code);

		});
	FRunnableThread* myThread1 = FRunnableThread::Create(webThread, TEXT("MyRunnableThread"));
#endif
}
