﻿// (CVN) - Candy Valley Network GmbH

#pragma once

#include <CoreMinimal.h>

// EXTERNAL INCLUDES

// INTERNAL INCLUDES
#include "Adapters/ILovenseAdapter.h"
#include "LovenseTypes.h"


/**
 * @brief Base class for all Lovense Connect adapters.
 */
class LovenseConnectAdapterBase : public ILovenseAdapter {
public:
	LovenseConnectAdapterBase();

#if WITH_LOVENSE
	virtual bool SendCommand_Stop(const FString& toyId, FOnLovenseResponse callback) override;
	virtual bool SendCommands(TArray<class UELovenseCommands*> commands, const FString& toyId, float timeSec, float loopRunningSec, float loopPauseSec, FOnLovenseResponse callback) override;
	virtual bool SendCommand_Preset(const FString& toyId, const FString& name, float timeSec, FOnLovenseResponse callback) override;
	virtual bool SendCommand_Pattern(const FString& toyId, FLovensePattern& pattern, FOnLovenseResponse callback) override;
	virtual bool SendPosition(int position, const FString& toyId, FOnLovenseResponse callback) override;
	virtual bool SetUpPatternV2(TArray<class UEPositionPatternValue*> positionValues, const FString& toyId, FOnLovenseResponse callback) override;
	virtual bool StartPatternV2(const FString& toyId, int startTime, int offsetTime, FOnLovenseResponse callback) override;
	virtual bool StopPatternV2(const FString& toyId,  FOnLovenseResponse callback) override;
	virtual bool GetPatternV2SyncTime(FOnLovenseResponse callback) override;
#endif

protected:
	virtual void ParseToyDescription(FLovenseToyDescription& toyDescription, TSharedPtr<class FJsonObject> toyObject) override;
};
