// Fill out your copyright notice in the Description page of Project Settings.

#pragma once
#include "Async/Async.h"               // UE5
#include "LovenseTypes.h"
#include "LovenseIntegration.h"
#include "LovenseManager.h"
#include <CoreMinimal.h>
#include <HAL/Runnable.h>
#include <HAL/RunnableThread.h>

THIRD_PARTY_INCLUDES_START
#include <curl/curl.h>
THIRD_PARTY_INCLUDES_END


//#include "LovenseManager.h"
/**
 * 
 */
class LovenseWebThread :public FRunnable {
public:
	LovenseWebThread(const FString url, bool bIgnoreSSL, FString method, FString body, TMap<FString, FString> headers, FString threadName, TFunction<void(FString)> Callback):url(url), bIgnoreSSL(bIgnoreSSL), method(method), body(body), headers(headers), threadName(threadName), Callback(Callback) {
	}

	LovenseWebThread(const FString url, bool bIgnoreSSL, FString method, FString body, TMap<FString, FString> headers, FString threadName, FOnLovenseGetAdaptersResponse getAdapter,TFunction<void(FString, FOnLovenseGetAdaptersResponse)> Callback) :url(url), bIgnoreSSL(bIgnoreSSL), method(method), body(body), headers(headers), threadName(threadName), CallbackGetRemote(Callback), getAdapter(getAdapter){
	}

	LovenseWebThread(const FString url, bool bIgnoreSSL, FString method, FString body, TMap<FString, FString> headers, FString threadName, FOnLovenseGetToysResponse getToys, TFunction<void(FString, FOnLovenseGetToysResponse)> Callback) :url(url), bIgnoreSSL(bIgnoreSSL), method(method), body(body), headers(headers), threadName(threadName), CallbackGetToys(Callback), getToys(getToys) {
	}

	LovenseWebThread(const FString url, bool bIgnoreSSL, FString method, FString body, TMap<FString, FString> headers, FString threadName, FOnLovenseResponse cmdResponse, TFunction<void(FString, FOnLovenseResponse)> CallbackCmdResponse) :url(url), bIgnoreSSL(bIgnoreSSL), method(method), body(body), headers(headers), threadName(threadName), CallbackCmdResponse(CallbackCmdResponse), cmdResponse(cmdResponse) {
	}
	

	
	void PauseThread();				
	void WakeUpThread();			
	void StopThread();				
	void Suspend(bool bSuspend);	
	void Reset();
	void UnReset();



private:
	bool bReset = false;
	const FString url;
	bool bIgnoreSSL;
	FString method;
	FString body;
	TMap<FString, FString> headers;
	FString threadName;
	TFunction<void(FString)> Callback;
	TFunction<void(FString, FOnLovenseGetAdaptersResponse)> CallbackGetRemote;
	FOnLovenseGetAdaptersResponse getAdapter;

	TFunction<void(FString, FOnLovenseGetToysResponse)> CallbackGetToys;
	FOnLovenseGetToysResponse getToys;

	TFunction<void(FString, FOnLovenseResponse)> CallbackCmdResponse;
	FOnLovenseResponse cmdResponse;

	


	FString responseString;

	bool Init();
	uint32 Run();
	void Stop();
	void Exit();
};
