// (CVN) - Candy Valley Network GmbH

using UnrealBuildTool;
using System.IO;

public class LovenseIntegration : ModuleRules
{
	public LovenseIntegration(ReadOnlyTargetRules Target) : base(Target)
	{
		Type = ModuleType.CPlusPlus;
		PrecompileForTargets = PrecompileTargetsType.Any;
		PCHUsage = ModuleRules.PCHUsageMode.UseExplicitOrSharedPCHs;
#if UE_4_24_OR_LATER
		bLegacyPublicIncludePaths = true;
#endif

		PublicDefinitions.Add("WITH_LOVENSE=1");

		PublicIncludePaths.AddRange(
			new string[] {
				Path.Combine(ModuleDirectory, "Public"),
				// ... add public include paths required here ...
				//Path.Combine(EngineDirectory, "Source","ThirdParty","libcurl","include")
				
			}
			);


		PrivateIncludePaths.AddRange(
			new string[] {
				"LovenseIntegration/Classes",
				"LovenseIntegration/Private",
				// ... add other private include paths required here ...
			}
			);


		PublicDependencyModuleNames.AddRange(
			new string[]
			{
				"Core",
				"CoreUObject",
				"Engine",
				"InputCore",
				"ApplicationCore",
				"RenderCore",
				"Json",
				"JsonUtilities",
				"HTTP",
				"WebSockets",
				 "libcurl" ,
				 "OpenSSL",
				 "zlib",
				 "libWebSockets"
				// ... add other public dependencies that you statically link with here ...
			}
			);


		PrivateDependencyModuleNames.AddRange(
			new string[]
			{
				"Slate",
				"SlateCore",
				"Projects"
				// ... add private dependencies that you statically link with here ...	
			}
			);


		DynamicallyLoadedModuleNames.AddRange(
			new string[]
			{
				// ... add any modules that your module loads dynamically here ...
			}
			);

		//AddThirdPartyPrivateStaticDependencies(Target, "libcurl");
	}
}
