// (CVN) - Candy Valley Network GmbH

#pragma once

#include <CoreMinimal.h>

// EXTERNAL INCLUDES

// INTERNAL INCLUDES
#include "Adapters/LovenseConnectAdapterBase.h"

#include "LovenseWebThread.h"

/**
 * @brief Abstract base class for Lovense Connect mobile adapters.
 */
class LovenseConnectMobileAdapter : public LovenseConnectAdapterBase {
public:
	LovenseConnectMobileAdapter();

protected:
	virtual void GetToys(FOnLovenseGetToysResponse callback) override;
	virtual void WebThread_SendCommand(const FString& command, FOnLovenseResponse callback) override;

#if WITH_LOVENSE
	/**
	 * @brief The android Lovense Connect app uses POST now for some reason.
	 * \n This also means we can't support both android and ios with our offline adapter anymore as we can't know the device without jumping through a bunch of extra hoops.
	 * \n We default to android behaviour as there are more android phones in the world.
	 */
	virtual FString GetVerb() = 0;
#endif
};


/**
 * @brief Adapter representing the Lovense Connect android app.
 */
class LovenseConnectAndroidAdapter : public LovenseConnectMobileAdapter {
public:
	LovenseConnectAndroidAdapter() : LovenseConnectMobileAdapter() {}

#if WITH_LOVENSE
	virtual FString GetVerb() override { return TEXT("POST"); }
#endif
};


/**
 * @brief Adapter representing the Lovense Connect iOS app.
 */
class LovenseConnectIOSAdapter : public LovenseConnectMobileAdapter {
public:
	LovenseConnectIOSAdapter() : LovenseConnectMobileAdapter() {}

#if WITH_LOVENSE
	virtual FString GetVerb() override { return TEXT("GET"); }
#endif
};
