// (CVN) - Candy Valley Network GmbH

#pragma once

#include <CoreMinimal.h>

// EXTERNAL INCLUDES

// INTERNAL INCLUDES

#include "LovenseEvents.generated.h"


/** @brief Blueprint exposed event delegate called when the lovense integration has started. */
DECLARE_DYNAMIC_MULTICAST_DELEGATE(FOnLovenseStarted);
/** @brief Blueprint exposed event delegate called when the lovense integration has stopped. */
DECLARE_DYNAMIC_MULTICAST_DELEGATE(FOnLovenseStopped);
/** @brief Blueprint exposed event delegate called when the currently active adapters have changed. */
DECLARE_DYNAMIC_MULTICAST_DELEGATE(FOnLovenseUpdatedAdapters);
/** @brief Blueprint exposed event delegate called when adapter information has successfully been requested (Only request, we are waiting for a response at this point). */
DECLARE_DYNAMIC_MULTICAST_DELEGATE(FOnLovenseStartedUpdatingAdapters);
/** @brief Blueprint exposed event delegate called when the currently active toys have changed. */
DECLARE_DYNAMIC_MULTICAST_DELEGATE(FOnLovenseUpdatedToys);


/**
 * @brief Object holding global Lovense Integration delegates.
 */
UCLASS()
class LOVENSEINTEGRATION_API ULovenseEvents : public UObject {
	GENERATED_BODY()

public:
	ULovenseEvents();

public:
	/** @brief Called when the lovense integration has started. */
	UPROPERTY(BlueprintAssignable, Category = "Lovense")
	FOnLovenseStarted onLovenseStarted;

	/** @brief Called when the lovense integration has stopped. */
	UPROPERTY(BlueprintAssignable, Category = "Lovense")
	FOnLovenseStopped onLovenseStopped;

	/** @brief Called when the currently active adapters have changed. */
	UPROPERTY(BlueprintAssignable, Category = "Lovense")
	FOnLovenseUpdatedAdapters onLovenseUpdatedAdapters;

	/** @brief Called when adapter information has successfully been requested (Only request, we are waiting for a response at this point). */
	UPROPERTY(BlueprintAssignable, Category = "Lovense")
	FOnLovenseStartedUpdatingAdapters onLovenseStartedUpdatingAdapters;

	/** @brief Called when the currently active toys have changed. */
	UPROPERTY(BlueprintAssignable, Category = "Lovense")
	FOnLovenseUpdatedToys onLovenseUpdatedToys;
};
