﻿# Import Lovense SDK Functions
init python:
    import sys
    import os
    sys.path.append(config.gamedir + "/lovenseplugin")

    import LovenseRemoteSDK

    # Wrapper functions for testing each SDK call
    def test_get_toys():
        try:
            renpy.notify(f"GetToys success: {lovense_toys}")
        except Exception as e:
            renpy.notify(f"GetToys error: {str(e)}")


    def test_vibrate_all():
        try:
            LovenseRemoteSDK.SendFunctions("", "Vibrate:10", 5)
            renpy.notify("Vibrate command sent successfully")
        except Exception as e:
            renpy.notify(f"Vibrate error: {str(e)}")

    def test_send_preset_all():
        try:
            LovenseRemoteSDK.SendPresetPattern("", "pulse", 5)
            renpy.notify("Preset Pattern `Pulse` command sent successfully")
        except Exception as e:
            renpy.notify(f"Preset Pattern error: {str(e)}")

    def test_send_pattern_all():
        try:
            commands = "V:1;F:v;S:1000#"
            strengthValues = "20;20;5;20;10"
            LovenseRemoteSDK.SendPattern("", commands, strengthValues, 5)
            renpy.notify("Pattern command sent successfully")
        except Exception as e:
            renpy.notify(f"Pattern error: {str(e)}")

    def test_stop_all():
        try:
            LovenseRemoteSDK.SendStopFunction("")
            renpy.notify("Stop command sent successfully")
        except Exception as e:
            renpy.notify(f"Stop error: {str(e)}")

    def test_send_patternv2_setup():
        try:
            actions = [
                {"ts": 0, "pos": 41},
                {"ts": 400, "pos": 92},
                {"ts": 800, "pos": 14},
                {"ts": 1200, "pos": 30},
                {"ts": 1600, "pos": 74},
                {"ts": 2000, "pos": 55},
                {"ts": 2400, "pos": 81},
                {"ts": 2800, "pos": 39},
                {"ts": 3200, "pos": 85},
                {"ts": 3600, "pos": 16},
                {"ts": 4000, "pos": 55},
                {"ts": 4400, "pos": 36},
                {"ts": 4800, "pos": 45},
                {"ts": 5200, "pos": 52}
                ]
            LovenseRemoteSDK.SendPatternV2Setup(actions)
            renpy.notify("PatternV2 Setup sent successfully")
        except Exception as e:
            renpy.notify(f"PatternV2 Setup error: {str(e)}")

    def test_send_patternv2_play():
        try:
            LovenseRemoteSDK.SendPatternV2Play("", 0, 0)
            renpy.notify("PatternV2 Start sent successfully")
        except Exception as e:
            renpy.notify(f"Start PatternV2 error: {str(e)}")

    def test_get_patternv2_synctime():
        try:
            data = LovenseRemoteSDK.GetPatternV2SyncTime()
            renpy.notify(f"PatternV2 Sync Time request sent successfully. Synctime: {data} secs")
        except Exception as e:
            renpy.notify(f"Get PatternV2 Sync Time error: {str(e)}")

    def test_stop_patternv2():
        try:
            LovenseRemoteSDK.StopPatternV2("")
            renpy.notify("PatternV2 Stop sent successfully")
        except Exception as e:
            renpy.notify(f"Stop PatternV2 error: {str(e)}")

# Game flow starts here
label start:

    if lovense_connected_domain and len(lovense_toys) > 0:
        "🔗 Connected! Remote Game Mode activated at: [lovense_connected_domain]"
    else:
        "⚠️ No Lovense toys detected. Please return to Settings and connect your toys first!"
        return

    scene black
    with fade

    "🎮 Welcome to the Lovense Full API Test Demo!"
    "Let's take your toys for a fun test drive 🚗💨"
   
    # --- Step 1: GetToys ---
    "📦 Step 1: Checking what toys are connected..."
    $ test_get_toys()
    pause 5

    # --- Step 2: SendFunctions (Vibrate) ---
    "🎵 Step 2: Sending a simple Vibrate command!"
    $ test_vibrate_all()
    pause 5

    # --- Step 3: SendPresetPattern ---
    "🎼 Step 3: Let's try a built-in preset: 'pulse'!"
    $ test_send_preset_all()
    pause 5

    # --- Step 4: SendPattern ---
    "🎨 Step 4: Crafting a custom pattern with strength variations!"
    $ test_send_pattern_all()
    pause 5

    # --- Step 5: SendStopFunction ---
    "🛑 Step 5: Stopping all actions to catch a breath."
    $ test_stop_all()
    pause 5

    # --- Step 6: SendPatternV2Setup (Only for Solace Pro) ---
    "🛠️ Step 6: Setting up an advanced PatternV2 sequence."
    $ test_send_patternv2_setup()
    pause 5

    # --- Step 7: PlayPatternV2 (Only for Solace Pro) ---
    "▶️ Step 7: Playing the PatternV2 we just created!"
    $ test_send_patternv2_play()
    pause 5

    # --- Step 8: GetPatternV2SyncTime ---
    "⏱️ Step 8: Synchronizing time for perfect pattern playback."
    $ test_get_patternv2_synctime()
    pause 5

    # --- Step 9: StopPatternV2 ---
    "🛑 Step 9: Stopping the PatternV2 sequence."
    $ test_stop_patternv2()
    pause 5

    "🎉 All API functions have been successfully tested!"
    "📖 For full codes, check 'screen.rpy' and 'script.rpy'."
    "🏁 Demo complete. Thanks for playing!"
    
    return