# Lovense Remote SDK for Python/Ren'Py

## Overview
This SDK provides a simple Python interface for interacting with Lovense toys via the Game Mode API.

It is designed for easy integration into visual novels, interactive games, and custom scripts.

Official API Reference: [Lovense Standard API](https://developer.lovense.com/docs/standard-solutions/standard-api.html)

---

## Directory Structure

| File/Folder         | Description |
|---------------------|-------------|
| `LovenseRemoteSDK.py` | Main unified SDK wrapper |
| `LvsConstant.py`      | Domain URL storage |
| `Toys.py`             | Fetch connected toys |
| `Functions.py`        | Send vibration/action commands |
| `Pattern.py`          | Send custom or preset patterns |
| `PatternV2.py`        | Advanced pattern control (PatternV2 for Solace Pro) |
| `StopFunction.py`     | Stop current toy actions |
| `PositionCommand.py`  | Send positioning commands (for Solace Pro) |

---

## Quick Start

### 1. Convert IP Address to Domain

```python
from LovenseRemoteSDK import ConvertIpToDomain

domain, message = ConvertIpToDomain("192.168.1.1", 30010)
print(domain)
```

=>result:"https://192-168-1-1.lovense.club:30010"

