# PositionCommand.py
# Send position control commands to Solace Pro toys

import requests
from LvsConstant import LvsConstant

def SendPositionCommand(toy_ids, pos):
    """
    Move the toy to a specific position (Solace Pro only).
    """
    url = f"{LvsConstant.domainUrl}/command"
    data = {
        "command": "Position",
        "value": pos,
        "toy": toy_ids,
        "apiVer": 1
    }

    response = requests.post(url, json=data)
    if response.status_code == 200:
        print(f"✅ SendPositionCommand Response: {response.json()}")
    else:
        print(f"❌ SendPositionCommand Failed. Status Code: {response.status_code}")
    return response