# Toys.py
# Manage connected Lovense toys

import requests
from LvsConstant import LvsConstant

def GetToys(domain_url):
    """
    Fetch the list of connected toys.
    
    Example API response:
    {
        "code": 200,
        "data": {
            "toys": {
                "ca771e9552be": {
                    "id": "ca771e9552be",
                    "name": "ferri",
                    "status": "1",
                    "battery": 86,
                    "nickName": "",
                    "version": "",
                    "shortFunctionNames": ["v"],
                    "fullFunctionNames": ["Vibrate"]
                },
                "286847ae60ca": {
                    "id": "286847ae60ca",
                    "name": "lush",
                    "status": "1",
                    "battery": 100,
                    "nickName": "",
                    "version": "4",
                    "shortFunctionNames": ["v"],
                    "fullFunctionNames": ["Vibrate"]
                }
            }
        }
    }
    """
    LvsConstant.domainUrl = domain_url
    url = f"{LvsConstant.domainUrl}/command"
    data = {'command': 'GetToys'}

    response = requests.post(url, json=data)
    if response.status_code == 200:
        toys_info = response.json()
        print(f"✅ Toys Info: {toys_info}")
        return toys_info
    else:
        print(f"❌ Failed to fetch toys. Status Code: {response.status_code}")
        return None
    
