# StopFunction.py
# Stop currently running functions on Lovense toys

import requests
from LvsConstant import LvsConstant

def SendStopFunction(toys):
    """
    Immediately stop all running actions on toys.
    """
    url = f"{LvsConstant.domainUrl}/command"
    data = {
        "command": "Function",
        "action": "Stop",
        "timeSec": 0,
        "toy": toys,
        "apiVer": 1
    }

    response = requests.post(url, json=data)
    if response.status_code == 200:
        print(f"✅ SendStopFunction Response: {response.json()}")
    else:
        print(f"❌ SendStopFunction Failed. Status Code: {response.status_code}")