# Pattern.py
# Manage sending preset patterns and custom patterns to Lovense toys

import requests
from LvsConstant import LvsConstant

def SendPattern(toy, types, strength_values, time_sec):
    """
    Send a custom pattern to a toy.
    """
    url = f"{LvsConstant.domainUrl}/command"
    data = {
        "command": "Pattern",
        "rule": types,
        "strength": strength_values,
        "timeSec": time_sec,
        "toy": toy,
        "apiVer": 2
    }

    response = requests.post(url, json=data)
    if response.status_code == 200:
        print(f"✅ SendPattern Response: {response.json()}")
    else:
        print(f"❌ SendPattern Failed. Status Code: {response.status_code}")

def SendPresetPattern(toys, preset_name, time_sec):
    """
    Send a preset vibration pattern to toys.
    We provide four preset patterns in the Lovense Remote app: pulse, wave, fireworks, earthquake
    """
    url = f"{LvsConstant.domainUrl}/command"
    data = {
        "command": "Preset",
        "name": preset_name,
        "timeSec": time_sec,
        "toy": toys,
        "apiVer": 1
    }

    response = requests.post(url, json=data)
    if response.status_code == 200:
        print(f"✅ SendPresetPattern Response: {response.json()}")
    else:
        print(f"❌ SendPresetPattern Failed. Status Code: {response.status_code}")