# Functions.py
# Send basic functions to Lovense toys (vibration, movement, etc.)

import requests
from LvsConstant import LvsConstant

def SendFunctions(toys, commands, time_sec, loop_running_sec=None, loop_pause_sec=None, stop_previous=None):
    """
    Send function command to Lovense toys.
    """
    url = f"{LvsConstant.domainUrl}/command"
    data = {
        "command": "Function",
        "action": commands,
        "timeSec": time_sec,
        "toy": toys,
        "apiVer": 1
    }

    if loop_running_sec is not None:
        data["loopRunningSec"] = loop_running_sec
    if loop_pause_sec is not None:
        data["loopPauseSec"] = loop_pause_sec
    if stop_previous is not None:
        data["stopPrevious"] = stop_previous

    response = requests.post(url, json=data)
    if response.status_code == 200:
        result = response.json()
        print(f"✅ SendFunctions Response: {result}")
        return result
    else:
        print(f"❌ SendFunctions Failed. Status Code: {response.status_code}")
        return None