//
//  ToyDetailHeaderView.swift
//  SwiftDemo
//
//  Created by Lovense on 2024/7/2.
//

import UIKit

class ToyDetailHeaderView: UIView {
    let typeLabel = UILabel()
    let toyNameLabel = UILabel()
    let fullNameLabel = UILabel()
    let toyVersionLabel = UILabel()
    let macLabel = UILabel()
    let versionLabel = UILabel()
    let batteryLabel = UILabel()
    let moveLevelLabel = UILabel()
    let feedbackTextView = UITextView()
    var showSupportedCommands: (() -> Void)?
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        
        let width = UIScreen.main.bounds.size.width - 30
        self.backgroundColor = .white
        
        self.typeLabel.textColor = .black
        self.typeLabel.font = .systemFont(ofSize: 16)
        self.typeLabel.frame = .init(x: 15, y: 15, width: width, height: 20)
        self.addSubview(self.typeLabel)
        
        self.macLabel.textColor = .black
        self.macLabel.font = .systemFont(ofSize: 16)
        self.macLabel.frame = .init(x: 15, y: 40, width: width, height: 20)
        self.addSubview(self.macLabel)
        
        self.versionLabel.textColor = .black
        self.versionLabel.font = .systemFont(ofSize: 16)
        self.versionLabel.frame = .init(x: 15, y: 70, width: width, height: 20)
        self.addSubview(self.versionLabel)
        
        self.batteryLabel.textColor = .black
        self.batteryLabel.font = .systemFont(ofSize: 16)
        self.batteryLabel.frame = .init(x: 15, y: 100, width: width, height: 20)
        self.addSubview(self.batteryLabel)
        
        self.toyVersionLabel.textColor = .black
        self.toyVersionLabel.font = .systemFont(ofSize: 16)
        self.toyVersionLabel.frame = .init(x: 15, y: 130, width: width, height: 20)
        self.addSubview(self.toyVersionLabel)
        
        self.toyNameLabel.textColor = .black
        self.toyNameLabel.font = .systemFont(ofSize: 16)
        self.toyNameLabel.frame = .init(x: 15, y: 160, width: width, height: 20)
        self.addSubview(self.toyNameLabel)
        
        self.fullNameLabel.textColor = .black
        self.fullNameLabel.font = .systemFont(ofSize: 16)
        self.fullNameLabel.frame = .init(x: 15, y: 190, width: width, height: 20)
        self.addSubview(self.fullNameLabel)
        
        self.moveLevelLabel.textColor = .black
        self.moveLevelLabel.font = .systemFont(ofSize: 16)
        self.moveLevelLabel.frame = .init(x: 15, y: 220, width: width, height: 20)
        self.addSubview(self.moveLevelLabel)
        
        self.feedbackTextView.textColor = .black
        self.feedbackTextView.font = .systemFont(ofSize: 14)
        self.feedbackTextView.frame = .init(x: 15, y: 250, width: width, height: 100)
        self.addSubview(self.feedbackTextView)
        
        let showSupportedCommandsButton = UIButton(type: .system)
        showSupportedCommandsButton.setTitle("Show Supported Commands", for: .normal)
        showSupportedCommandsButton.titleLabel?.textAlignment = .center
        showSupportedCommandsButton.addTarget(self, action: #selector(self.onShowSupportedCommands), for: .touchUpInside)
        showSupportedCommandsButton.frame = .init(x: 15, y: 350, width: width, height: 44)
        showSupportedCommandsButton.layer.borderWidth = 1
        showSupportedCommandsButton.layer.borderColor = UIColor.systemBlue.cgColor
        showSupportedCommandsButton.layer.cornerRadius = 8
        showSupportedCommandsButton.layer.masksToBounds = true
        self.addSubview(showSupportedCommandsButton)
    }
    @objc func onShowSupportedCommands() {
        self.showSupportedCommands?()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
}
