//
//  ToyDetailCell.swift
//  SwiftDemo
//
//  Created by Lovense on 2024/7/2.
//

import UIKit

class ToyDetailCell: UITableViewCell {
    var slider: UISlider?
    var sliderValueLabel: UILabel?
    var sliderValueDesc: ((Int) -> String)?
    var btn: UIButton?
    lazy var inputTextField: UITextField = {
        let inputTextField = UITextField(frame: .init(x: 5, y: 10, width: UIScreen.main.bounds.size.width - 10, height: 30))
        inputTextField.borderStyle = .line
        inputTextField.layer.borderWidth = 1
        inputTextField.layer.borderColor = UIColor.black.cgColor
        self.contentView.addSubview(inputTextField)
        return inputTextField
    }()
    
    var multiInputs: [UITextField] = []
    var titleLabel: UILabel?
    
    var sliderChangeBlock: ((Int) -> Void)?
    var btnClickBlock: (() -> Void)?
    var multiCommandBlock: (([String]) -> Void)?
    
    func setSliderName(_ name: String, min: Int = 0, max: Int = 20, desc: ((Int) -> String)? = nil) {
        if let slider {
            self.textLabel?.text = name
        } else {
            self.textLabel?.numberOfLines = 0
            self.textLabel?.font = .systemFont(ofSize: 14)
            self.textLabel?.textAlignment = .center
            self.textLabel?.text = name
            let slider = UISlider(frame: .init(x: 15, y: 40, width: UIScreen.main.bounds.width - 30, height: 50))
            slider.minimumValue = Float(min)
            slider.maximumValue = Float(max)
            slider.value = 0
            slider.isContinuous = false
            slider.thumbTintColor = .blue
            slider.addTarget(self, action: #selector(self.sliderChange(_:)), for: .valueChanged)
            
            let minLabel = UILabel(frame: .init(x: 30, y: 20, width: 50, height: 20))
            minLabel.font = .systemFont(ofSize: 12)
            minLabel.text = min.description
            self.contentView.addSubview(minLabel)
            
            let sliderValueLabel = UILabel(frame: .init(x: UIScreen.main.bounds.size.width / 2 - 50, y: 20, width: 100, height: 20))
            sliderValueLabel.font = .boldSystemFont(ofSize: 13)
            sliderValueLabel.text = desc?(min) ?? min.description
            sliderValueLabel.textColor = .systemBlue
            sliderValueLabel.textAlignment = .center
            self.contentView.addSubview(sliderValueLabel)
            self.sliderValueLabel = sliderValueLabel
            
            let maxLabel = UILabel(frame: .init(x: UIScreen.main.bounds.width - 30, y: 20, width: 30, height: 20))
            maxLabel.font = .systemFont(ofSize: 12)
            maxLabel.text = max.description
            self.contentView.addSubview(maxLabel)
            
            self.contentView.addSubview(slider)
            self.slider = slider
        }
        self.sliderValueDesc = desc
    }
    func setBtnName(_ name: String) {
        if let btn {
            btn.setTitle(name, for: .normal)
        } else {
            let btn = UIButton(type: .system)
            btn.titleLabel?.numberOfLines = 2
            btn.titleLabel?.textAlignment = .center
            btn.setTitle(name, for: .normal)
            btn.frame = .init(x: 0, y: 10, width: UIScreen.main.bounds.size.width, height: 50)
            btn.addTarget(self, action: #selector(self.btnClick), for: .touchUpInside)
            self.contentView.addSubview(btn)
            self.btn = btn
        }
    }
    func setMultiInput(title titleName: String, placeHolders: [String] = [], sender btnName: String) {
        if self.titleLabel == nil {
            let titleLabel = UILabel(frame: .init(x: 6, y: 6, width: UIScreen.main.bounds.width - 12, height: 30))
            titleLabel.numberOfLines = 0
            titleLabel.font = .systemFont(ofSize: 14)
            titleLabel.textAlignment = .center
            titleLabel.text = titleName
            self.contentView.addSubview(titleLabel)
            self.titleLabel = titleLabel
        }
        let btnWidth: CGFloat = 70
        if self.btn == nil {
            let btn = UIButton(type: .system)
            btn.backgroundColor = .systemBlue
            btn.setTitle(btnName, for: .normal)
            btn.layer.cornerRadius = 3
            btn.layer.masksToBounds = true
            btn.setTitleColor(.white, for: .normal)
            btn.frame = .init(x: UIScreen.main.bounds.size.width - (btnWidth + 6), y: 42, width: btnWidth, height: 35)
            btn.addTarget(self, action: #selector(self.btnClick), for: .touchUpInside)
            self.contentView.addSubview(btn)
            self.btn = btn
        }
        let inputWidth = (UIScreen.main.bounds.size.width - (btnWidth + 12) - 18) / CGFloat(placeHolders.count)
        for i in 0..<placeHolders.count {
            if self.multiInputs.count > i {
                let input = self.multiInputs[i]
                input.placeholder = placeHolders[i]
            } else {
                let input = UITextField(frame: .init(x: 6 + (inputWidth + 6) * CGFloat(i), y: 42, width: inputWidth, height: 35))
                input.textAlignment = .center
                input.borderStyle = .line
                input.placeholder = placeHolders[i]
                input.layer.cornerRadius = 3
                input.layer.masksToBounds = true
                input.layer.borderWidth = 1
                input.layer.borderColor = UIColor.gray.cgColor
                self.contentView.addSubview(input)
                self.multiInputs.append(input)
            }
        }
        while placeHolders.count < multiInputs.count {
            multiInputs.popLast()?.removeFromSuperview()
        }
    }
    @objc func sliderChange(_ slider: UISlider) {
        self.sliderValueLabel?.text = (sliderValueDesc ?? { "\($0)" })(Int(slider.value))
        self.sliderChangeBlock?(Int(slider.value))
    }
    @objc func btnClick() {
        self.btnClickBlock?()
        
        if let multiCommandBlock {
            let values = self.multiInputs.map { $0.text ?? "" }
                .map { $0.isEmpty ? "-1" : $0 }
            multiCommandBlock(values)
        }
    }
}
