//
//  RootViewController.swift
//  LovenseDemo
//
//  Created by 范晓鑫 on 2024/8/5.
//

import UIKit

class RootViewController: UIViewController, UITableViewDataSource, UITableViewDelegate {
    let tableView = UITableView()
    let data = ["Lovense Toy", "Pattern Play"]
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        self.setupUI()
    }
    func setupUI() {
        self.title = "Example"
        self.view.backgroundColor = .white
        self.tableView.dataSource = self
        self.tableView.delegate = self
        self.tableView.frame = CGRectMake(0, 0, self.view.bounds.size.width, self.view.bounds.size.height)
        self.tableView.register(UITableViewCell.self, forCellReuseIdentifier: "Cell")
        self.view.addSubview(self.tableView)
    }
    
    // MARK: UITableViewDataSource methods
    
    func numberOfSections(in tableView: UITableView) -> Int {
        return 1
    }
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return self.data.count
    }
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withIdentifier: "Cell") ?? UITableViewCell()
        cell.textLabel?.text = data[indexPath.row]
        return cell
    }
    
    // MARK: UITableViewDelegate methods
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        switch indexPath.row {
        case 0:
            let vc = SearchToyViewController()
            self.navigationController?.pushViewController(vc, animated: true)
        case 1:
            let vc = ExampleForPatternViewController()
            self.navigationController?.pushViewController(vc, animated: true)
        default: break
        }
    }
}
