//
//  ToyDetailCell.m
//  DemoSdk
//
//  Created by Lovense on 2019/3/4.
//  Copyright © 2019 Hytto. All rights reserved.
//

#import "ToyDetailCell.h"
#define ScreenWidth [[UIScreen mainScreen] bounds].size.width
#define ScreenHeight [[UIScreen mainScreen] bounds].size.heigh

@interface ToyDetailCell()

@end

@implementation ToyDetailCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    self = [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self)
    {

    }
    return self;
}

-(void)setSliderName:(NSString *)sliderName
{
    if(!_slider)
    {
        self.textLabel.numberOfLines = 0;
        self.textLabel.font = [UIFont systemFontOfSize:14];
        self.textLabel.textAlignment = NSTextAlignmentCenter;
        [self.textLabel setText:sliderName];
        _slider = [[UISlider alloc]initWithFrame:CGRectMake(15 , 40, ScreenWidth-30, 50)];
        _slider.minimumValue = 0;
        _slider.maximumValue = 20;
        _slider.value = 0;
        _slider.continuous = NO;
        _slider.thumbTintColor = [UIColor blueColor];
        [_slider addTarget:self action:@selector(sliderChange:) forControlEvents:UIControlEventValueChanged];

        [self.contentView addSubview:_slider];
    }
    else
    {
        [self.textLabel setText:sliderName];
    }
}

-(void)setSliderName:(NSString *)sliderName andMinValue:(NSInteger)minValue andMaxValue:(NSInteger)maxValue
{
    if(!_slider)
    {
        self.textLabel.numberOfLines = 0;
        self.textLabel.font = [UIFont systemFontOfSize:14];
        self.textLabel.textAlignment = NSTextAlignmentCenter;
        [self.textLabel setText:sliderName];
        _slider = [[UISlider alloc]initWithFrame:CGRectMake(15 , 40, ScreenWidth-30, 50)];
        _slider.minimumValue = minValue;
        _slider.maximumValue = maxValue;
        _slider.value = 0;
        _slider.continuous = NO;
        _slider.thumbTintColor = [UIColor blueColor];
        [_slider addTarget:self action:@selector(sliderChange:) forControlEvents:UIControlEventValueChanged];

        UILabel * minLabel = [[UILabel alloc] initWithFrame:CGRectMake(30, 20, 50, 20)];
        minLabel.font = [UIFont systemFontOfSize:12];
        minLabel.text = [NSString stringWithFormat:@"%li",(long)minValue];
        [self.contentView addSubview:minLabel];

        UILabel * maxLabel = [[UILabel alloc] initWithFrame:CGRectMake(ScreenWidth - 30, 20, 30, 20)];
        maxLabel.font = [UIFont systemFontOfSize:12];
        maxLabel.text = [NSString stringWithFormat:@"%li",(long)maxValue];
        [self.contentView addSubview:maxLabel];

        [self.contentView addSubview:_slider];
    }
    else
    {
        [self.textLabel setText:sliderName];
    }
}

-(void)setMultInput:(NSString *)titleName andSendName: (NSString *) btnName
{
    if (!_titleLabel) {
        _titleLabel = [[UILabel alloc] initWithFrame:CGRectMake(6, 6, ScreenWidth - 12, 30)];
        _titleLabel.numberOfLines = 0;
        _titleLabel.font = [UIFont systemFontOfSize:14];
        _titleLabel.textAlignment = NSTextAlignmentCenter;
        [_titleLabel setText:titleName];
        
        [self.contentView addSubview:_titleLabel];
    }

    
    NSInteger btnWidth = 70;
    if(!_btn)
    {
        _btn = [UIButton buttonWithType:UIButtonTypeSystem];
        [_btn setBackgroundColor:[UIColor grayColor]];
        [_btn setTitle:btnName forState:UIControlStateNormal];
        _btn.layer.cornerRadius = 3;
        _btn.layer.masksToBounds = YES;
        [_btn setTitleColor: [UIColor whiteColor] forState:UIControlStateNormal];
        _btn.frame = CGRectMake(ScreenWidth - (btnWidth + 6), 42, btnWidth, 35);
        [_btn addTarget:self action:@selector(btnClick) forControlEvents:UIControlEventTouchUpInside];
        [self.contentView addSubview:_btn];
    }
    
    NSInteger inputWidth = (ScreenWidth - (btnWidth + 12) - 18) / 3 ;
    
    if(!_input1)
    {
        _input1 = [[UITextField alloc] initWithFrame:CGRectMake(6, 42, inputWidth, 35)];
        _input1.textAlignment = NSTextAlignmentCenter;
        _input1.borderStyle = UITextBorderStyleLine;
        _input1.placeholder = @"-1";
        _input1.layer.cornerRadius = 3;
        _input1.layer.masksToBounds = YES;
        _input1.layer.borderWidth = 1;
        _input1.layer.borderColor = [UIColor grayColor].CGColor;
        [self.contentView addSubview:_input1];
    }
    
    if(!_input2)
    {
        _input2 = [[UITextField alloc] initWithFrame:CGRectMake(6 + inputWidth + 6, 42, inputWidth, 35)];
        _input2.textAlignment = NSTextAlignmentCenter;
        _input2.borderStyle = UITextBorderStyleLine;
        _input2.placeholder = @"-1";
        _input2.layer.cornerRadius = 3;
        _input2.layer.masksToBounds = YES;
        _input2.layer.borderWidth = 1;
        _input2.layer.borderColor = [UIColor grayColor].CGColor;
        [self.contentView addSubview:_input2];
    }
    
    if(!_input3)
    {
        _input3 = [[UITextField alloc] initWithFrame:CGRectMake(6 + (inputWidth + 6) * 2.0, 42, inputWidth, 35)];
        _input3.textAlignment = NSTextAlignmentCenter;
        _input3.borderStyle = UITextBorderStyleLine;
        _input3.placeholder = @"-1";
        _input3.layer.cornerRadius = 3;
        _input3.layer.masksToBounds = YES;
        _input3.layer.borderWidth = 1;
        _input3.layer.borderColor = [UIColor grayColor].CGColor;
        [self.contentView addSubview:_input3];
    }
}


-(void)setBtnName:(NSString *)btnName
{
    if(!_btn)
    {
        _btn = [UIButton buttonWithType:UIButtonTypeSystem];
        [_btn setTitle:btnName forState:UIControlStateNormal];
        _btn.frame = CGRectMake(0, 10, ScreenWidth, 50);
        [_btn addTarget:self action:@selector(btnClick) forControlEvents:UIControlEventTouchUpInside];
        [self.contentView addSubview:_btn];
    }
    else
    {
        [_btn setTitle:btnName forState:UIControlStateNormal];
    }
}

-(UITextField*)inputTextField
{
    if(!_inputTextField)
    {
        _inputTextField = [[UITextField alloc] initWithFrame:CGRectMake(5, 10, ScreenWidth-10, 30)];
        _inputTextField.borderStyle = UITextBorderStyleLine;
        _inputTextField.layer.borderWidth = 1;
        _inputTextField.layer.borderColor = [UIColor blackColor].CGColor;
        [self.contentView addSubview:_inputTextField];
    }
    return _inputTextField;
}

-(void)sliderChange:(UISlider*)slider
{
    if(self.sliderChangeBlock)
        self.sliderChangeBlock(slider.value);
}

-(void)btnClick
{
    if(self.btnClickBlock)
        self.btnClickBlock();
    
    if (self.sendCommandBlock) {
        
        NSString *input1 = _input1.text;
        if (input1 == NULL || [input1  isEqual: @""]) {
            input1 = @"-1";
        }
        
        NSString *input2 = _input2.text;
        if (input2 == NULL || [input2  isEqual: @""]) {
            input2 = @"-1";
        }
        
        NSString *input3 = _input3.text;
        if (input3 == NULL || [input3  isEqual: @""]) {
            input3 = @"-1";
        }
        
        self.sendCommandBlock(input1, input2, input3);
    }
}

@end
