//
//  RootViewController.m
//  LovenseDemo
//
//  Created by 陈自豪 on 2023/5/26.
//  Copyright © 2023 June. All rights reserved.
//

#import "RootViewController.h"
#import "SearchToyVC.h"
#import "ExampleForPatternVC.h"
@interface RootViewController() <UITableViewDataSource, UITableViewDelegate>
@property (nonatomic, strong)  UITableView * tableView;
@property (nonatomic, strong)  NSMutableArray * data;
@end

@implementation RootViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self dataConfig];
    [self setupUI];
    
   
}
- (void)dataConfig {
    self.data = [[NSMutableArray alloc] init];
    [self.data addObject: @"Lovense Toy"];
    [self.data addObject: @"Pattern Play"];
}
- (void) setupUI {
    self.title = @"Example";
    self.view.backgroundColor = [UIColor whiteColor];
    [self.view addSubview: self.tableView];
    self.tableView.frame = CGRectMake(0, 0, self.view.bounds.size.width, self.view.bounds.size.height);
}

#pragma mark - UITableViewDataSource methods

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return self.data.count;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *cellIdentifier = @"Cell";
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:cellIdentifier];
    if (!cell) {
        cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellIdentifier];
        
       
    }
    cell.textLabel.text = self.data[indexPath.row];
    return cell;
}

#pragma mark - UITableViewDelegate methods

- (void) tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    NSString * title = self.data[indexPath.row];
    if ([title isEqualToString:@"Lovense Toy"]) {
        UIViewController * vc = [[SearchToyVC alloc]init];
        [self.navigationController pushViewController:vc animated: YES];
    } else if ([title isEqualToString:@"Pattern Play"]) {
        UIViewController * vc = [[ExampleForPatternVC alloc]init];
        [self.navigationController pushViewController:vc animated: YES];
    }
}




#pragma  mark - Lazy loading

- (UITableView*) tableView {
    if (!_tableView) {
        _tableView = [[UITableView alloc] init];
        _tableView.dataSource = self;
        _tableView.delegate = self;
    }
    return _tableView;
}
@end
