<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<!DOCTYPE html>
<html>
<head>
    <title>Demo</title>
    <style>
        .demo_div { float: left; }
        #get_code_table input[type=text] { width: 500px; padding: 3px 3px;}
        #get_code_table input[type=button] { margin: 20px 0 0 60px; font-size: 16px;}
        #get_qrcode_result { padding-left: 5px; }
        #get_qrcode_error { color: red; font-size: 20px;}
        #call_back_data { width: 900px; height: 800px; border: 1px solid #808080; overflow: auto;}
        #call_back_json {
            width: 100%;
            font-size: 18px;
            white-space: pre-wrap;
            word-wrap: break-word;
            background-color: white;
            border:0px;
        }
        .string { color: green; }
        .number { color: darkorange; }
        .boolean { color: blue; }
        .null { color: magenta; }
        .key { color: red; }
    </style>
    <script type="text/javascript" src="static/js/jquery.js"></script>
    <script type="text/javascript">
        $(function(){
            $("#get_qrcode_submit").click(function(){
                $("#get_qrcode_result .get_qrcode_div").hide();
                $.ajax({
                    url: "https://apps.lovense.com/api/lan/getQrCode",
                    type: "post",
                    data: $('#get_qrcode_form').serialize(),
                    success:function(data){
                        if(data.result) {
                            $("#get_qrcode_success img").attr("src", data.message);
                            $("#get_qrcode_success").show();
                        } else {
                            $("#get_qrcode_error").html(data.message);
                            $("#get_qrcode_error").show();
                        }
                    },
                    error: function(){
                        $("#get_qrcode_error").html("Error in call to API");
                        $("#get_qrcode_error").show();
                    }
                });
            });

            function getCallbackData() {
                $.ajax({
                    url: "http://${domain}/getCallback",
                    success:function(data){
                        if(data.result) {
                            $("#call_back_json").html(pretifyJson(data.data, true));
                        } else {
                            $("#call_back_data").html(data.message);
                        }
                    },
                    error: function(){
                        $("#call_back_data").html("Error in call to API");
                    }
                });
            }

            window.setInterval(getCallbackData, 3000);
        });

        function pretifyJson(json, pretify=true) {
            if (typeof json !== 'string') {
                if(pretify){
                    json = JSON.stringify(json, undefined, 4);
                }else{
                    json = JSON.stringify(json);
                }
            }
            return json.replace(/("(\\u[a-zA-Z0-9]{4}|\\[^u]|[^\\"])*"(\s*:)?|\b(true|false|null)\b|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?)/g,
                function (match) {
                    let cls = "<span>";
                    if (/^"/.test(match)) {
                        if (/:$/.test(match)) {
                            cls = "<span class='key'>";
                        } else {
                            cls = "<span class='string'>";
                        }
                    } else if (/true|false/.test(match)) {
                        cls = "<span class='boolean'>";
                    } else if (/null/.test(match)) {
                        cls = "<span class='null'>";
                    }
                    return cls + match + "</span>";
                }
            );
        }
    </script>
</head>
<body>
    <h1>Basic API Demo</h1>
    <div class="demo_div">
        <h4>Please set this URL <span style="color: red;">"${domain}"</span> as the callback url in the <a href="https://www.lovense.com/user/developer/info" target="_blank">developer dashboard</a></h4>
        <img src="static/img/dev.png" width="700" />
        <h3>API: Get Qrcode</h3>
        <form id="get_qrcode_form" method="post">
            <table id="get_code_table">
                <tr>
                    <td style="text-align: right;">developerToken:</td>
                    <td><input type="text" name="token" /></td>
                </tr>
                <tr>
                    <td style="text-align: right;">uid:</td>
                    <td><input type="text" name="uid" /></td>
                </tr>
                <tr>
                    <td style="text-align: right;">uname:</td>
                    <td><input type="text" name="uname" /></td>
                </tr>
                <tr>
                    <td colspan="2"><input type="button" value="Get Qrcode" id="get_qrcode_submit" /></td>
                </tr>
            </table>
        </form>
        <h3>API result: Get Qrcode</h3>
        <div id="get_qrcode_result">
            <div class="get_qrcode_div" id="get_qrcode_error"></div>
            <div class="get_qrcode_div" id="get_qrcode_success"><img id="qrcode" src="" /></div>
        </div>
    </div>
    <div class="demo_div" style="margin-left: 50px;">
        <h3>Call back data</h3>
        <div id="call_back_data">
            <pre id="call_back_json"></pre>
        </div>
    </div>
</body>
</html>
