package com.lovense.basicapi.controller;

import com.lovense.basicapi.utils.MessageResponse;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;

@RequestMapping("/")
@CrossOrigin
@Controller
public class DemoController {

    private Map<String, Object> callbackData = new HashMap<>();

    @Value("${server.port}")
    private String port;

    @RequestMapping("/")
    public String index(Model model) throws UnknownHostException {
        model.addAttribute("domain", InetAddress.getLocalHost().getHostAddress() + ":" + port);
        return "index";
    }

    @RequestMapping("/callback")
    @ResponseBody
    public MessageResponse callback(@RequestBody Map data) {
        if(data != null && !data.isEmpty()) {
            callbackData = data;
        }
        return MessageResponse.bulidSuccess(null);
    }

    @RequestMapping("/getCallback")
    @ResponseBody
    public MessageResponse getCallback() {
        return MessageResponse.bulidSuccess(callbackData);
    }
}
