package com.lovense.sdkdemo

import android.annotation.SuppressLint
import android.content.Context
import android.content.Intent
import android.view.LayoutInflater
import android.view.ViewGroup
import androidx.core.view.isVisible
import androidx.recyclerview.widget.RecyclerView
import com.lovense.sdkdemo.databinding.ItemToyBinding
import com.lovense.sdklibrary.LovenseToy

/**
 * Created by Lovense on 2019/5/14
 *
 * Copyright © 2019 Hytto. All rights reserved.
 */
class ToyAdapter(private var context: Context, private var toyList: List<LovenseToy>) : RecyclerView.Adapter<ToyAdapter.ViewHolder>() {
    override fun onCreateViewHolder(viewGroup: ViewGroup, i: Int): ViewHolder {
        val binding = ItemToyBinding.inflate(LayoutInflater.from(context), null, false)
        return ViewHolder(binding)
    }

    @SuppressLint("SetTextI18n")
    override fun onBindViewHolder(viewHolder: ViewHolder, i: Int) {
        val toy = toyList[i]
        viewHolder.binding.tvName.text = "name：" + toy.deviceName
        viewHolder.binding.tvId.text = "ID：" + toy.toyId
        viewHolder.binding.tvRssi.text = "RSSI：" + toy.rssi + " ; Type：" + toy.type

        // -1 lovenseToy disconnected 1:lovenseToy connected
        viewHolder.binding.tvStatu.text = "status：" + if (toy.status == 1) "connected" else "not connected"

        viewHolder.binding.llToy.setOnClickListener {
            val intent = Intent(context, ToyActivity::class.java)
            intent.putExtra("toyId", toy.toyId)
            context.startActivity(intent)
        }
        viewHolder.binding.btPlayPattern.isVisible = false
        viewHolder.binding.btPlayPattern.setOnClickListener {
            val intent = Intent(context, PatternPlayActivity::class.java)
            intent.putExtra("toyId", toy.toyId)
            context.startActivity(intent)
        }
    }

    override fun getItemCount(): Int {
        return toyList.size
    }

    class ViewHolder(val binding: ItemToyBinding) : RecyclerView.ViewHolder(binding.root)
}
